using System;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
	/// <summary>
	/// This exception is thrown if client for some reason is not authorized to 
	/// perform remote procedure call on listener.
	/// </summary>
	public class PublishedProcedureNotFoundException : VistALinkException
	{
		/// <summary>
		/// Initializes a new instance of <see cref="PublishedProcedureNotFoundException"/> class.
		/// </summary>
		public PublishedProcedureNotFoundException() 
			: base( "Published procedure was not found in the list of published procedures." ) {}

		/// <summary>
		/// Initializes a new instance of <see cref="PublishedProcedureNotFoundException"/> 
		/// class with a specified error message.
		/// </summary>
		/// <param name="message">The message that describes the error.</param>
		public PublishedProcedureNotFoundException( string message ) 
			: base( message ) {}

		/// <summary>
		/// Initializes a new instance of the <see cref="PublishedProcedureNotFoundException"/> class 
		/// with a specified error message and a reference to the inner 
		/// exception that is the cause of this exception.
		/// </summary>
		/// <param name="message">The message that describes the error.</param>
		/// <param name="innerException">The exception that is the cause of the current exception.</param>
		public PublishedProcedureNotFoundException( string message, Exception innerException ) 
			: base( message, innerException ) {}
	}
}
